// Included Files
//
#include "driverlib.h"
#include "device.h"

#ifdef _FLASH
// These are defined by the linker (see device linker command file)
extern uint16_t RamfuncsLoadStart;
extern uint16_t RamfuncsLoadSize;
extern uint16_t RamfuncsRunStart;
#endif

uint16_t counter = 0;
unsigned char *msg;

// Function Prototypes
__interrupt void sciaTxISR(void);
__interrupt void sciaRxISR(void);
// Send data for SCI-A
uint16_t sDataA[9];
unsigned int uart_num=0;

void main(void)
{
    Device_init();
    Device_initGPIO();
    // GPIO28 is the SCI Rx pin.
    GPIO_setMasterCore(DEVICE_GPIO_PIN_SCIRXDA, GPIO_CORE_CPU1);
    GPIO_setPinConfig(DEVICE_GPIO_CFG_SCIRXDA);
    GPIO_setDirectionMode(DEVICE_GPIO_PIN_SCIRXDA, GPIO_DIR_MODE_IN);
    GPIO_setPadConfig(DEVICE_GPIO_PIN_SCIRXDA, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(DEVICE_GPIO_PIN_SCIRXDA, GPIO_QUAL_ASYNC);

    // GPIO29 is the SCI Tx pin.
    GPIO_setMasterCore(DEVICE_GPIO_PIN_SCITXDA, GPIO_CORE_CPU1);
    GPIO_setPinConfig(DEVICE_GPIO_CFG_SCITXDA);
    GPIO_setDirectionMode(DEVICE_GPIO_PIN_SCITXDA, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(DEVICE_GPIO_PIN_SCITXDA, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(DEVICE_GPIO_PIN_SCITXDA, GPIO_QUAL_ASYNC);

    // Disable global interrupts.
    DINT;
    // Initialize interrupt controller and vector table.
    Interrupt_initModule();
    Interrupt_initVectorTable();
    IER = 0x0000;
    IFR = 0x0000;

    // Map the ISR to the wake interrupt.
    Interrupt_register(INT_SCIA_TX, sciaTxISR);
    Interrupt_register(INT_SCIA_RX, sciaRxISR);
    // Initialize SCIA and its FIFO.
    SCI_performSoftwareReset(SCIA_BASE);
    // Configure SCIA for echoback.
    // SCI_setConfig(SCIA_BASE, 25000000, 9600, (SCI_CONFIG_WLEN_8 |SCI_CONFIG_STOP_ONE |SCI_CONFIG_PAR_NONE));
    SCI_setConfig(SCIA_BASE, 25000000, 115200, (SCI_CONFIG_WLEN_8 |SCI_CONFIG_STOP_ONE |SCI_CONFIG_PAR_NONE));
    SCI_resetChannels(SCIA_BASE);
    SCI_clearInterruptStatus(SCIA_BASE, SCI_INT_TXFF | SCI_INT_RXFF);
    SCI_enableFIFO(SCIA_BASE);
    SCI_enableModule(SCIA_BASE);
    SCI_performSoftwareReset(SCIA_BASE);
    // Set the transmit FIFO level to 0 and the receive FIFO level to 2.
    // Enable the TXFF and RXFF interrupts.
    SCI_setFIFOInterruptLevel(SCIA_BASE, SCI_FIFO_TX0, SCI_FIFO_RX2);
    SCI_enableInterrupt(SCIA_BASE, SCI_INT_TXFF | SCI_INT_RXFF);

    // Clear the SCI interrupts before enabling them.
    SCI_clearInterruptStatus(SCIA_BASE, SCI_INT_TXFF | SCI_INT_RXFF);

    // Enable the interrupts in the PIE: Group 9 interrupts 1 & 2.
    Interrupt_enable(INT_SCIA_RX);
    Interrupt_enable(INT_SCIA_TX);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);
    // Enable global interrupts.
    EINT;
    for(;;)
    {
        uart_num++;
        if(uart_num>1000)
        {
            uart_num=0;
           // sDataA[0]=0x12;sDataA[1]=0x34;sDataA[2]=0x56;sDataA[3]=0x78;sDataA[4]=0x9A;sDataA[5]=0xBC;sDataA[6]=0xDE;sDataA[7]=0xFF;
            sDataA[0]=0x55;sDataA[1]=0xAA;sDataA[2]=0x55;sDataA[3]=0xAA;sDataA[4]=0x55;sDataA[5]=0xAA;sDataA[6]=0x55;sDataA[7]=0xAA;
           SCI_writeCharArray(SCIA_BASE, sDataA, 8);
           // SCI_writeCharArray(SCIA_BASE, 0x55, 1);
            SysCtl_delay(1000); SysCtl_delay(1000); SysCtl_delay(1000);
        }
    }
}
// sciaTxISR - Disable the TXFF interrupt and print message asking for two characters.
__interrupt void sciaTxISR(void)
{
    // Disable the TXRDY interrupt.
    SCI_disableInterrupt(SCIA_BASE, SCI_INT_TXFF);

    msg = "\r\nEnter two characters: \0";
    SCI_writeCharArray(SCIA_BASE, (uint16_t*)msg, 26);
    // Acknowledge the PIE interrupt.
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);
}
// sciaRxISR - Read two characters from the RXBUF and echo them back.
__interrupt void sciaRxISR(void)
{
    uint16_t receivedChar1, receivedChar2;
    // Enable the TXFF interrupt again.
    SCI_enableInterrupt(SCIA_BASE, SCI_INT_TXFF);
    // Read two characters from the FIFO.
    receivedChar1 = SCI_readCharBlockingFIFO(SCIA_BASE);
    receivedChar2 = SCI_readCharBlockingFIFO(SCIA_BASE);
    // Echo back the two characters.
    msg = "  You sent: \0";
    SCI_writeCharArray(SCIA_BASE, (uint16_t*)msg, 13);
    SCI_writeCharBlockingFIFO(SCIA_BASE, receivedChar1);
    SCI_writeCharBlockingFIFO(SCIA_BASE, receivedChar2);
    // Clear the SCI RXFF interrupt and acknowledge the PIE interrupt.
    SCI_clearInterruptStatus(SCIA_BASE, SCI_INT_RXFF);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);

    counter++;
}
// End of File

